<?php
function generateAIMessage($prompt) {
    $proxyUrl = 'https://cool-art-fd42.mrmadanoglu12.workers.dev/'; // kendi Worker URL'in

    $data = [
        "contents" => [[
            "role" => "user",
            "parts" => [["text" => $prompt]]
        ]],
        "generationConfig" => [
            "temperature" => 0.7,
            "topK" => 40,
            "topP" => 0.95,
            "maxOutputTokens" => 1024
        ],
        "safetySettings" => [
            ["category" => "HARM_CATEGORY_HATE_SPEECH", "threshold" => 3],
            ["category" => "HARM_CATEGORY_SEXUALLY_EXPLICIT", "threshold" => 3],
            ["category" => "HARM_CATEGORY_DANGEROUS_CONTENT", "threshold" => 3],
            ["category" => "HARM_CATEGORY_HARASSMENT", "threshold" => 3],
            ["category" => "HARM_CATEGORY_CIVIC_INTEGRITY", "threshold" => 3]
        ]
    ];

    $ch = curl_init($proxyUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ["Content-Type: application/json"],
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_TIMEOUT => 15
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if (!$response) {
        return '❌ CURL HATASI: ' . $error;
    }

    $json = json_decode($response, true);
    return $json['candidates'][0]['content']['parts'][0]['text'] ?? 'Yanıt alınamadı.';
}

?>
