<?php
date_default_timezone_set('Europe/Istanbul');

// === Zaman kontrolü ===
$today = date('Y-m-d');
$nowHour = (int) date('H');
$nowMinute = (int) date('i');
file_put_contents(__DIR__ . '/log_schedule.txt', "Çalıştı @ $nowHour:$nowMinute\n", FILE_APPEND);

if (!($nowHour === 8 && $nowMinute === 30)) {
    exit("⏳ Şu an $nowHour:$nowMinute — üretim zamanı değil.\n");
}

// === Saatler oluştur ===
$schedule = [
    'date'      => $today,
    'morning'   => sprintf('%02d:%02d', 9, rand(30, 59)),
    'newleads'  => sprintf('%02d:%02d', 11, rand(30, 59)),
    'lunch'     => sprintf('%02d:%02d', 13, rand(5, 15)),
    'crm'       => sprintf('%02d:%02d', 14, rand(10, 45)),
    'followup'  => sprintf('%02d:%02d', 17, rand(10, 50)),
    'thanks'    => sprintf('%02d:%02d', 18, rand(5, 30))
];

// === JSON dosyasına kaydet ===
file_put_contents(__DIR__ . '/schedule.json', json_encode($schedule, JSON_PRETTY_PRINT));
file_put_contents(__DIR__ . '/log_schedule.txt', "✅ Yeni saatler yazıldı\n", FILE_APPEND);

// === Telegram mesajı hazırla ===
require_once __DIR__ . '/vv.php';

$telegramMessage = "📅 <b>Günlük Plan Saatleri Üretildi</b>\n"
    . "📆 <b>Tarih:</b> <code>{$schedule['date']}</code>\n"
    . "🕒 <b>Sabah Mesajı:</b> <code>{$schedule['morning']}</code>\n"
    . "🆕 <b>Yeni Lead Kontrol:</b> <code>{$schedule['newleads']}</code>\n"
    . "🍽 <b>Öğle Yemeği:</b> <code>{$schedule['lunch']}</code>\n"
    . "📋 <b>CRM Takibi:</b> <code>{$schedule['crm']}</code>\n"
    . "🔁 <b>Takip Mesajı:</b> <code>{$schedule['followup']}</code>\n"
    . "🙏 <b>Teşekkür Mesajı:</b> <code>{$schedule['thanks']}</code>\n";

sendTelegramMessage($telegramMessage, true); // ✅ Sabitlemeli gönderim
