
<?php
require_once __DIR__ . '/ai.php';
require_once __DIR__ . '/v.php';

date_default_timezone_set('Europe/Istanbul');

// Sadece CLI'dan çalıştırılabilir
if (php_sapi_name() !== 'cli') {
    http_response_code(403);
    exit("⛔ Bu dosya sadece cron (CLI) ile çalıştırılabilir.");
}

// === ZAMAN & DOSYALAR
$nowTime = date('H:i');
$today = date('Y-m-d');
$logFile = __DIR__ . '/log.txt';
file_put_contents($logFile, "\n\n⏰ Cron çalıştı: $nowTime\n", FILE_APPEND);

// === VERİLERİ YÜKLE
$config     = require __DIR__ . '/token.php';
$recipients = json_decode(file_get_contents(__DIR__ . '/recipients.json'), true);
$schedule   = json_decode(file_get_contents(__DIR__ . '/schedule.json'), true);

// === PROMPT TANIMLARI (Varyasyon Havuzları ile)
$prompts = [
    [
        'id' => 'morning',
        'time' => $schedule['morning'],
        'text' => [
            "Sen Hosfinder’da pozitif bir ekip üyesisin. [name] adlı [gender] satış danışmanı için [lang] dilinde enerjik ve dostça bir günaydın mesajı yaz. Kısa, motive edici, WhatsApp formatında, emojili olsun.",
            "[name] adlı [gender] satış danışmanı için [lang] dilinde yeni güne umut dolu bir günaydın mesajı yaz. İçten, samimi ve enerjik olsun. Emojiler ekle. Açıklama yok, sadece mesaj.",
            "[lang] dilinde [name] için günün başlangıcında moral verici bir günaydın mesajı hazırla. Dostane, eğlenceli, motive edici olsun. WhatsApp tarzında yaz, emoji kullan.",
            "Pozitif bir ekip arkadaşı olarak [name] için [lang] dilinde güne keyifli başlamasını sağlayacak motive edici bir mesaj yaz. Samimi, enerjik, kısa olsun. Emojili yaz."
        ]
    ],
    [
        'id' => 'newleads',
        'time' => $schedule['newleads'],
        'text' => [
            "[name] için yeni dataların geldiğini kibarca hatırlatan bir mesaj yaz. Bol satışlar dile, motive edici olsun. [lang] dilinde, WhatsApp formatında, emojili yaz.",
            "Yeni dataların [name]’e ulaştığını belirten kısa ve samimi bir mesaj üret. Satışlara moral versin. [lang] dilinde, dostça, motive edici olsun.",
            "[name] için ‘yeni fırsatlar geldi’ tarzında heyecanlı bir mesaj yaz. Bol satışlar dile. [lang] dilinde, WhatsApp’a uygun, emojili olsun.",
            "[name]’e yeni datalarının hazır olduğunu belirt. Kısa, enerjik, motive edici yaz. [lang] dilinde, samimi olsun. Emoji kullan."
        ]
    ],
    [
        'id' => 'lunch',
        'time' => $schedule['lunch'],
        'text' => [
            "[name] için öğle molasında enerjisini tazeleyecek kısa bir mesaj yaz. [lang] dilinde, samimi, rahatlatıcı olsun. Emoji ekle.",
            "[name] için öğle arasında motive edici, hafif ve dostça bir mesaj yaz. [lang] dilinde, WhatsApp tarzında, emojili olsun.",
            "[name]’e öğle molasında iyi dileklerini ileten, keyifli ve enerjik bir mesaj yaz. [lang] dilinde, kısa ve içten olsun.",
            "Öğle molasında [name] için moral verici, dinlendirici bir mesaj hazırla. [lang] dilinde, WhatsApp formatında, emojiyle destekle."
        ]
    ],
    [
        'id' => 'crm',
        'time' => $schedule['crm'],
        'text' => [
            "[name] için CRM notlarını güncellemesi gerektiğini hatırlatan kısa bir mesaj yaz. [lang] dilinde, dostça ve motive edici olsun. Emoji kullan.",
            "[name]’e CRM güncellemesi yapmasını kibarca hatırlat. [lang] dilinde, kısa ve samimi bir mesaj yaz. WhatsApp tarzında olsun.",
            "CRM notlarını güncellemesi için [name]’e enerjik ve motive edici bir hatırlatma mesajı yaz. [lang] dilinde, emoji ekle.",
            "[name] için CRM update zamanı geldiğini belirten dostça bir mesaj oluştur. [lang] dilinde, pozitif ve kısa olsun."
        ]
    ],
    [
        'id' => 'followup',
        'time' => $schedule['followup'],
        'text' => [
            "[name] için daily follow-up zamanının geldiğini hatırlatan profesyonel bir mesaj yaz. [lang] dilinde, kısa ve güven veren olsun.",
            "Follow-up vakti geldiğini [name]’e motive edici şekilde hatırlat. [lang] dilinde, net ve pozitif bir mesaj yaz.",
            "[name] için takip zamanının geldiğini belirten, kısa ve motive edici bir mesaj oluştur. [lang] dilinde, WhatsApp tarzında, profesyonel olsun.",
            "[name]’e daily follow-up zamanı olduğunu kibarca hatırlat. [lang] dilinde, güven veren ve motive edici yaz. Emoji kullanılabilir."
        ]
    ],
    [
        'id' => 'thanks',
        'time' => $schedule['thanks'],
        'text' => [
            "[name] için günün sonunda teşekkür eden, yorgunluğunu takdir eden pozitif bir mesaj yaz. [lang] dilinde, WhatsApp formatında, emoji ekle.",
            "[name]’e günün sonunda emeğine sağlık diyen, dostça bir teşekkür mesajı üret. [lang] dilinde, kısa ve içten olsun.",
            "Günün bitiminde [name] için moral verici, samimi ve takdir dolu bir teşekkür mesajı yaz. [lang] dilinde, emoji kullanılabilir.",
            "[name] için günü kapatırken teşekkür eden, motive edici ve sıcak bir mesaj oluştur. [lang] dilinde, WhatsApp tarzında olsun."
        ]
    ]
];


// === MESAJLARI ZAMANINA GÖRE KONTROL ET
foreach ($prompts as $prompt) {
    if ($prompt['time'] === $nowTime) {
        file_put_contents($logFile, "🎯 Saat eşleşti → {$prompt['id']} @ {$nowTime}\n", FILE_APPEND);

        foreach ($recipients as $r) {
            $finalPrompt = str_replace(
                ['[name]', '[gender]', '[lang]'],
                [$r['name'], $r['gender'], $r['lang']],
                $prompt['text']
            );

            $aiMessage = generateAIMessage($finalPrompt, $config['gemini']['api_key']);
            if ($aiMessage) {
                file_put_contents($logFile, "🤖 {$prompt['id']} → {$r['name']}: $aiMessage\n", FILE_APPEND);

                sendWhatsappMessage(
                    $prompt['id'],
                    $r['name'],
                    $r['phone'],
                    $aiMessage,
                    $config['whatsapp']['access_token'],
                    $config['whatsapp']['phone_number_id']
                );
            } else {
                file_put_contents($logFile, "⚠️ AI mesajı alınamadı: {$r['name']} → {$prompt['id']}\n", FILE_APPEND);
            }
        }
    }
}

// === MESAJ GÖNDERİCİ (WhatsApp + Telegram)
function sendWhatsappMessage($promptId, $recipientName, $phone, $message) {
    // token.php dosyasından config yükle
    $config = require __DIR__ . '/token.php';

    $productId = $config['whatsapp']['access_tokens'];     // Maytapi product_id
    $phoneId   = $config['whatsapp']['phone_number_id'];   // Maytapi phone_id
    $maytapiKey = $config['whatsapp']['maytapi_key'];  // x-maytapi-key

    // API URL oluştur
    $url = "https://api.maytapi.com/api/{$productId}/{$phoneId}/sendMessage";

    // Mesaj verisi
    $data = [
        "to_number" => $phone,
        "type"      => "text",
        "message"   => $message,
        "typing"    => "typing",
        "duration"  => 2
    ];

    $headers = [
        "Accept: application/json",
        "Content-Type: application/json",
        "x-maytapi-key: $maytapiKey"
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => $headers
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        file_put_contents(__DIR__ . "/log.txt", "❌ WHATSAPP HATA: $error\n", FILE_APPEND);
    } else {
        $logMsg = "✅ Mesaj gönderildi → $phone\nYanıt: $response\n";
        file_put_contents(__DIR__ . "/log.txt", $logMsg, FILE_APPEND);

        $telegramMessage = "📤 <b>Mesaj Gönderildi</b>\n"
            . "🆔 <b>Prompt:</b> <code>{$promptId}</code>\n"
            . "👤 <b>Kime:</b> {$recipientName}\n"
            . "📱 <b>Telefon:</b> <code>{$phone}</code>\n"
            . "🕒 <b>Saat:</b> " . date('H:i') . "\n"
            . "💬 <b>Mesaj:</b>\n" . htmlspecialchars($message);

        sendTelegramMessage($telegramMessage);
    }
}
